<?php 
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBackgrounds extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetBackground($mod_id , $type = 1, $system = false) {
		global $_CONF , $_TSM, $base;

		//device detection tablet
		if ($base->isTablet) {
				$cond = " AND find_in_set(2,image_device) ";
		} elseif ($base->isMobile) {
				//phone
				$cond = " AND find_in_set(3,image_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,image_device) ";
			}



		if ($system) {

			if ($mod_id != null) {
				$img = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['core:backgrounds']},
						{$this->tables['core:backgrounds_assigns']}
					WHERE 
						find_in_set({$mod_id} , bg_modules_global) AND
						bg_type = {$type} AND 
						bg_background = image_id AND
						image_status = 1
						{$cond}
						ORDER BY rand() limit 1"
				);
			}
			
		} else {
			
			$img = $this->db->QFetchArray("
				SELECT * FROM 
					{$this->tables['core:backgrounds']},
					{$this->tables['core:backgrounds_assigns']}
				WHERE 
					find_in_set({$mod_id} , bg_modules) AND	
					bg_type = {$type} AND 
					bg_background = image_id AND
					image_status = 1
					{$cond}
					ORDER BY rand() limit 1
				"
			);
		}

		//load the default if exits
		if (!is_array($img)) {
			$img = $this->db->QFetchArray("

				SELECT * FROM 
					{$this->tables['core:backgrounds']},
					{$this->tables['core:backgrounds_assigns']}
				WHERE 
					bg_default=1 AND
					bg_type = {$type} AND 
					bg_background = image_id AND
					image_status = 1
					{$cond}
					ORDER BY rand() limit 1
				"
			);
		}
		
		if (is_array($img)) {
			return $this->GetBg($img);
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"				=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetBg($id, $extra = array()) {

		$this->__init();

		if (!$id) {
			return array(
				"class"		=> "",
				"html"		=> "",
			);
		}

		if (is_array($id)) {
			$background = $id;

			if ($this->cache[$id["image_id"]]) {
				return $this->cache[$id["image_id"]];
			}
			
		} else {		
			//get the background

			if ($this->cache[$id]) {
				return $this->cache[$id];
			}

			if (is_array($this->bgs[$id])) {
				$background = $this->bgs[$id];
 			} else {			
				$background = $this->db->QFetchArray(
					"SELECT * FROM {$this->tables['core:backgrounds']} WHERE image_id={$id} AND image_status=1 "
				);
			}
		}

		if (!is_array($background)) {
			return array(
				"class"		=> "",
				"html"		=> "",
			);
		}
		
		$background["extra_html_class"] = $extra["html_class"];

		$this->__init();

		switch ($background["image_type"]) {

			//image
			case "1":

				switch ($background["image_effect"]) {
					//none
					case "0":				
						$background["fixed"] = $background["image_img_fixed"] ? "fixed" : "scroll";

						$html = $this->_t("main")->blockReplace(
							"Image" , 
							$background , 
							array(
								"color"	=> $background["image_color"] ? 
									$this->_t("main")->blockreplace(
										"ImageColor" , 
										$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
										array("alpha" => $background["image_color_alpha"])
								) : "",
							)
						);
					break;

					//parallax
					case "1":
						$html = $this->_t("main")->BlockReplace(
							"Parallax" , 
							$background , 
							array(
								"color"	=> $background["image_color"] ? 
									$this->_t("main")->blockreplace(
										"ImageColor" , 
										$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
										array("alpha" => $background["image_color_alpha"])
								) : "",
							)
						);
					break;

					//kenburns
					case "2":
						$html = $this->_t("main")->BlockReplace(
							"Kenburn" , 
							$background,
							array(
								"color"	=> $background["image_color"] ? 
									$this->_t("main")->blockreplace(
										"ImageColor" , 
										$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
										array("alpha" => $background["image_color_alpha"])
								) : "",
							)						
						);
					break;

					//simple scroller
					case "3":
						$html = $this->_t("main")->BlockReplace(
							"Scroller" , 
							$background,
							array(
								"color"	=> $background["image_color"] ? 
									$this->_t("main")->blockreplace(
										"ImageColor" , 
										$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
										array("alpha" => $background["image_color_alpha"])
								) : "",
							)
						);
					break;

					//simple scroller
					case "4":
						$html = $this->_t("main")->BlockReplace(
							"ScrollerHover" , 
							$background,
							array(
								"color"	=> $background["image_color"] ? 
									$this->_t("main")->blockreplace(
										"ImageColor" , 
										$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
										array("alpha" => $background["image_color_alpha"])
								) : "",
							)
						);
					break;

				}
			break;

			//video
			case "2":
				$html = $this->_t("main")->BlockReplace("Video" , $background);
			break;

			//solid color
			case "3":
				$html = $this->_t("main")->blockreplace(
					"Color" , 
					$this->plugins["layouts"]->Hex2Rgb($background["image_color"])  , 
					array("alpha" => $background["image_color_alpha"]),
					$background
				);
			break;


			//youtube
			case "100":
				$html = $this->_t("main")->BlockReplace("Youtube" , $background);
			break;

			//slider
			case "5":
				$images = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:backgrounds_slides']} WHERE slide_parent={$background[image_id]} ORDER BY rand()");
				
				if (is_array($images)) {
					$img = array();
					foreach ($images as $key => $val) {
						$img[] = "upload/backgrounds/slides/slide_{$val[slide_id]}.jpg";
					}

					$background["image_slider_transition"] = str_Replace("," , " " , $background["image_slider_transition"]);

					$html = $this->_t("main")->BlockReplace(
						"Slider" , 
						$background,
						array(
							"images"	=> json_encode($img)
						)
					);

					
				}
				
			break;
				
			//youtube
			case "6":
				$html = $this->_t("main")->BlockReplace("Transparent" , $background);
			break;

			//gradient
			case "7":

				
				//process rgba 
				$background["image_color_start_a"] = $this->hex2rgba($background["image_color_start"] , $background["image_color_start_alpha"]);
				$background["image_color_end_a"] = $this->hex2rgba($background["image_color_end"] , $background["image_color_end_alpha"]);

				$background["image_color_start_ie"] =  "#" . dechex($background["image_color_start_alpha"] * 255 ). str_replace("#" , "" , $background["image_color_start"]);
				$background["image_color_end_ie"] =  "#" . dechex($background["image_color_end_alpha"] * 255 ). str_replace("#" , "" , $background["image_color_end"]);
				
				$html = $this->_t("main")->BlockReplace("Gradient_" . $background["image_color_dir"] , $background);
			break;

			case "8":

				$left = $this->GetBg($background["image_split_bg1"]);
				$right = $this->GetBg($background["image_split_bg2"]);

				$html = $this->_t("main")->BlockReplace(
					"Split", 
					array(
						"left_html"		=> $left["html"],
						"left_class"	=> $left["class"],
						"right_html"	=> $right["html"],
						"right_class"	=> $right["class"],

						"image_split_size_r"		=> 100 - $background["image_split_size"],
						"image_split_size_lg_r"		=> 100 - $background["image_split_size_lg"],
						"image_split_size_md_r"		=> 100 - $background["image_split_size_md"],
						"image_split_size_sm_r"		=> 100 - $background["image_split_size_md"],
						"image_split_size_xs_r"		=> 100 - $background["image_split_size_xs"],
					),
					$background
				);
			
			break;

		}

		$scheme = "";

		switch ($background["image_inverted"]) {
			case "1":
				$class .= " ic "; //. $this->_t("main")->blockReplace("Inverted");
				$scheme = "ic";

			break;

			case "2":
				$class .= " nc ";// . $this->_t("main")->blockReplace("Normal");
				$scheme = "nc";
			break;
		}


		if ($background["image_overlay"]) {
			$background["overlay"] = $this->plugins["skineditor"]->Overlay($background["image_overlay"]);
		} else {
			$background["overlay"] = "";
		}

		//particles.js
		if ($background["image_particles"]) {

			if ($background["image_overlay"]) {
				$html = CTemplateStatic::Replace($html , array("overlay" => ""));
			}

			$html .= $this->_t("main")->blockReplace("ParticlesJS" , $background);
		}

		$html = CTemplateStatic::Replace($html , array("overlay" => $background["overlay"]));

		
		$this->cache[$background["image_id"]] = array(
			"class"		=> " with-background " . $class,
			"html"		=> $html,
		);

		if ($scheme != "") {
			$this->cache[$background["image_id"]]["bg:scheme"] = $scheme;
		}
		


		return $this->cache[$background["image_id"]];
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		return "";

		global $_TSM;

		if ($module["mod_id"]) {
			$bgs = $this->GetPageBgs($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$bgs = $this->GetPageBgs($module["module_id"] , true);
		} 

		//full page backgrounds
		$_TSM["PUB:PAGE_BG_HTML"] = "";
		$_TSM["PUB:PAGE_BG_CLASS"] = "";

		if (is_array($bgs["1"])) {
			$bg = $this->GetBg($bgs["1"]);
			$_TSM["PUB:PAGE_BG_HTML"] = $bg["html"];
			$_TSM["PUB:PAGE_BG_CLASS"] = $bg["class"];
		}

		//menu backgrounds
		$_TSM["PUB:MENU_BG_HTML"] = "";
		$_TSM["PUB:MENU_BG_CLASS"] = "normal-colors";
		$_TSM["PUB:HEADER_BG_HTML"] = "";
		$_TSM["PUB:HEADER_BG_CLASS"] = "normal-colors";

		$_TSM["PUB:HEADERS_BG_HTML"] = "";
		$_TSM["PUB:HEADERS_BG_CLASS"] = "normal-colors";

		$_TSM["PUB:MENUS_BG_HTML"] = "";
		$_TSM["PUB:MENUS_BG_CLASS"] = "";
		$_TSM["PUB:SECMENU_BG_HTML"] = "";
		$_TSM["PUB:SECMENU_BG_CLASS"] = "normal-colors";

		if (is_array($bgs["3"])) {

			$bg = $this->GetBg($bgs["3"]);

############# PROBLEM DE REFACUT
/*			$_TSM["PUB:HEADER_BG_CLASS"] = 
				str_replace(
					"inverted-colors" , 
					"" , 
					str_replace(
						"normal-colors" , 
						"" , 
						$bg["class"]
					)
				);
*/
			//check if it has sticky background
			if ($bgs["3"]["bg_background_sticky"]) {				
				$bg_s = $this->GetBg($bgs["3"]["bg_background_sticky"]);
				
				//add an extra class so i can remove it 
				$_TSM["PUB:MENUS_BG_HTML"] = str_replace("background " , "background background-sticky " , $bg_s["html"]);
				$_TSM["PUB:MENUS_BG_CLASS"] = $bg_s["class"];

				$_TSM["PUB:HEADERS_BG_HTML"] = str_replace("background " , "background background-sticky " , $bg_s["html"]);
				$_TSM["PUB:HEADERS_BG_CLASS"] = $bg_s["class"];
			}

			//normal menu
			if ($bgs[3]["bg_background"]) {
				$_TSM["PUB:MENU_BG_HTML"] = $bg["html"];
				$_TSM["PUB:MENU_BG_CLASS"] = $bg["class"];

				$_TSM["PUB:HEADER_BG_HTML"] = $bg["html"];
				$_TSM["PUB:HEADER_BG_CLASS"] = $bg["class"];

			}

			//secondary nav
			if ($bgs["3"]["bg_background_sec"]) {
				$bg_s = $this->GetBg($bgs["3"]["bg_background_sec"]);

				$_TSM["PUB:SECMENU_BG_HTML"] = $bg_s["html"];
				$_TSM["PUB:SECMENU_BG_CLASS"] = $bg_s["class"];
			}
		} 

		//fix the pagetitle backgroun
		$_TSM["PUB:PAGETITLE_BG_HTML"] = "";
		$_TSM["PUB:PAGETITLE_BG_CLASS"] = "";

		if (is_array($bgs["2"])) {
			$bg = $this->GetBg($bgs["2"]);
			$_TSM["PUB:PAGETITLE_BG_HTML"] = $bg["html"];
			$_TSM["PUB:PAGETITLE_BG_CLASS"] = $bg["class"];
		}
		

		//fix the pagetitle backgroun
		$_TSM["PUB:PAGE_MAIN_HTML"] = "";
		$_TSM["PUB:PAGE_MAIN_CLASS"] = "";

		if (is_array($bgs["5"])) {
			$bg = $this->GetBg($bgs["5"]);
			$_TSM["PUB:PAGE_MAIN_HTML"] = $bg["html"];
			$_TSM["PUB:PAGE_MAIN_CLASS"] = $bg["class"];
		}


		//footer backgrounds
		$_TSM["PUB:PAGE_FOOT_HTML"] = "";
		$_TSM["PUB:PAGE_FOOT_CLASS"] = "";

		if (is_array($bgs["4"])) {
			$bg = $this->GetBg($bgs["4"]);
			$_TSM["PUB:PAGE_FOOT_HTML"] = $bg["html"];
			$_TSM["PUB:PAGE_FOOT_CLASS"] = $bg["class"];
		}
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetPageBgs($id , $system = false) {
		global $base;

		//device detection tablet
		if ($base->isTablet) {
				$cond = " AND find_in_set(2,image_device) ";
		} elseif ($base->isMobile) {
				//phone
				$cond = " AND find_in_set(3,image_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,image_device) ";
			}

/*
		$ids = $this->db->QFetchRowArray("
			SELECT (
				SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE (find_in_set({$id} , " . ( $system ? "bg_modules_global" : "bg_modules") .") OR bg_default = 1 ) AND bg_type=1 ORDER BY rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id) as bg_1,
		");
*/

		$bg_cond = "(find_in_set({$id} , " . ( $system ? "bg_modules_global" : "bg_modules") .") OR bg_default = 1 ) AND ";
		$ids = $this->db->QFetchArray("select 
			(SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE  {$bg_cond} bg_type=5 ORDER BY bg_default ASC , rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id) as bg_5,

			(SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE  {$bg_cond} bg_type=4 ORDER BY bg_default ASC , rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id) as bg_4,

			(SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE  {$bg_cond} bg_type=3 ORDER BY bg_default ASC , rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id) as bg_3,

			(SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE {$bg_cond} bg_type=2 ORDER BY bg_default ASC , rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id ) as bg_2,

			(SELECT p.bg_id FROM site_core_backgrounds_assigns as p INNER JOIN ( SELECT t.bg_id FROM site_core_backgrounds_assigns t WHERE {$bg_cond} bg_type=1 ORDER BY bg_default ASC , rand() LIMIT 1) as p2 ON p2.bg_id = p.bg_id ) as bg_1
		");

		//get all the images
		$imgs = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['core:backgrounds']}
			LEFT JOIN
				{$this->tables['core:backgrounds_assigns']} 
			ON
				image_id = bg_background 
			WHERE
				bg_id in (%d, %d,%d,%d,%d)			
			",
			array($ids["bg_1"],$ids["bg_2"],$ids["bg_3"],$ids["bg_4"],$ids["bg_5"])
		);

		if (is_Array($imgs)) {
			foreach ($imgs as $key => $val) {

				switch ($val["bg_type"]) {
					//menu treat special
					case "3":
						$this->bgs[$val["image_id"]] = $val;

						$other = $this->db->QFetchRowArray("
							SELECT * FROM 
								{$this->tables['core:backgrounds']}
							LEFT JOIN
								{$this->tables['core:backgrounds_assigns']} 
							ON
								image_id = bg_id 
							WHERE
								bg_id in (%d, %d,%d,%d,%d ,%d)			
							",
							array(
								$val["bg_background_sec"],
								$val["bg_background_sec_sticky"],
								$val["bg_background_sticky"],
								$val["bg_background_collapse_bar"],
								$val["bg_background_collapse_main"],
								$val["bg_background_collapse_sec"],
							)
						);

						if (is_array($other)) {
							foreach ($other as $k => $v) {
								$this->bgs[$v["image_id"]] = $v;
							}
							
						}

						$return[$val["bg_type"]] = $val;
					break;

					default:
						$this->bgs[$val["image_id"]] = $val;

						$return[$val["bg_type"]] = $val;
					break;
				}
				
			}			
		}
				
		return $return;

	}

	
	function hex2rgba($hex , $alpha) {
	   $hex = str_replace("#", "", $hex);

	   if(strlen($hex) == 3) {
		  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
		  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
		  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
		  $r = hexdec(substr($hex,0,2));
		  $g = hexdec(substr($hex,2,2));
		  $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array("r"	=> $r, "g"	=> $g, "b"	=> $b);
	   //return implode(",", $rgb); // returns the rgb values separated by commas

	   return "rgba(" . $r . "," . $g . "," . $b . "," . $alpha . ")" ;//$rgb; // returns an array with the rgb values
	}

}

?>